from __future__ import generators
import plus
import Arenas
import random
import Hazards
import math


class BoxArena(Arenas.SuperArena):
    "Watch out for rolling boulders as you fight in these caverns!"
    name = "DSL Cave Arena"
    preview = "DSLCaveArena/DSLCaveArena_preview.bmp"
    game_types = ['DEATHMATCH', 'BATTLE ROYAL', 'TEAM MATCH']
    extent = (-45, 25, 45, -25)

    def __init__(self):
        Arenas.SuperArena.__init__(self, "Arenas/DSLCaveArena/DSLCaveArena.gmf")
        #plus.Arena.__init__(self, "")
        plus.setBackColor(0,0,0)
        degrad = 0.01745
       
        self.AddStaticCamera("                Overhead Cam 1", (-18, 27, -2), (90*degrad, 0*degrad), degrad*90)
        self.AddStaticCamera("                Overhead Cam 2", (16, 27, 0), (90*degrad, 0*degrad), degrad*90)
        self.AddStaticCamera("                Pit Action", (45, 24, -14), (50.5*degrad, 340*degrad), degrad*90)
        self.AddStaticCamera("                Boulder Cam", (0, 8, 30), (20*degrad, 180*degrad), degrad*35)

        self.AddWatchCamera("                Big Rock Cam", (-23, 14, 2), (20, 40, 60*degrad, 20*degrad))
        self.AddWatchCamera("                Panning Cam", (0, 18, 0), (12, 30, 45*degrad, 45*degrad))
        self.AddWatchCamera("                Close Follow", (0, 24, 0), (20, 40, 30*degrad, 12*degrad))
        self.AddWatchCamera("                Mid Follow", (0, 24, 0), (20, 40, 45*degrad, 22*degrad))
        self.AddWatchCamera("                Far Follow", (0, 24, 0), (20, 40, 60*degrad, 37*degrad))
        self.AddWatchCamera("                Pit Watch Cam", (35, 24, 0), (20, 40, 60*degrad, 37*degrad))
        
        
        self.players = ()
        self.nextrock = 11
        self.boltimer = 0


        
    def AddShadowReceivers(self):
        self.SetShadowSource(5.897, 19.159, 5.899)
        
        #Main Arena Floor Shadow Triangles
        self.AddShadowTriangle((-10.2877,0.051,1.83754), (-12.4182,0.051,12.4283), (-12.4182,0.051,1.83754))
        self.AddShadowTriangle((-8.17686,0.051,9.91855), (-8.17686,0.051,12.4283), (-12.4182,0.051,12.4283))
        self.AddShadowTriangle((-8.17686,0.051,9.91855), (-12.4182,0.051,12.4283), (-10.2877,0.051,1.83754))
        self.AddShadowTriangle((2.25999,0.051,12.4283), (-2.49123,0.051,12.4283), (-2.49123,0.051,9.91855))
        self.AddShadowTriangle((2.25999,0.051,9.91855), (2.25999,0.051,12.4283), (-2.49123,0.051,9.91855))
        self.AddShadowTriangle((12.413,0.051,12.4283), (7.93297,0.051,12.4283), (7.93297,0.051,9.91855))
        self.AddShadowTriangle((10.2878,0.051,1.91641), (12.413,0.051,12.4283), (7.93297,0.051,9.91855))
        self.AddShadowTriangle((10.2878,0.051,1.91641), (12.413,0.051,1.91641), (12.413,0.051,12.4283))
        self.AddShadowTriangle((8.17711,0.051,-9.92447), (12.413,0.051,-12.4279), (10.2878,0.051,-1.93329))
        self.AddShadowTriangle((10.2878,0.051,-1.93329), (12.413,0.051,-12.4279), (12.413,0.051,-1.93329))
        self.AddShadowTriangle((8.17711,0.051,-9.92447), (8.17711,0.051,-12.4279), (12.413,0.051,-12.4279))
        self.AddShadowTriangle((-2.26871,0.051,-12.4279), (2.49519,0.051,-12.4279), (2.49519,0.051,-9.92447))
        self.AddShadowTriangle((-2.26871,0.051,-9.92447), (-2.26871,0.051,-12.4279), (2.49519,0.051,-9.92447))
        self.AddShadowTriangle((-12.4182,0.051,-12.4279), (-7.93688,0.051,-12.4279), (-7.93688,0.051,-9.92447))
        self.AddShadowTriangle((-10.2877,0.051,-1.8361), (-12.4182,0.051,-12.4279), (-7.93688,0.051,-9.92447))
        self.AddShadowTriangle((-10.2877,0.051,-1.8361), (-12.4182,0.051,-1.8361), (-12.4182,0.051,-12.4279))
        self.AddShadowTriangle((-2.49123,0.051,9.91855), (-8.17686,0.051,9.91855), (-10.2877,0.051,1.83754))
        self.AddShadowTriangle((2.49519,0.051,-9.92447), (8.17711,0.051,-9.92447), (10.2878,0.051,-1.93329))
        self.AddShadowTriangle((10.2878,0.051,-1.93329), (-10.2877,0.051,-1.8361), (-2.26871,0.051,-9.92447))
        self.AddShadowTriangle((10.2878,0.051,1.91641), (7.93297,0.051,9.91855), (2.25999,0.051,9.91855))
        self.AddShadowTriangle((2.25999,0.051,9.91855), (-2.49123,0.051,9.91855), (-10.2877,0.051,1.83754))
        self.AddShadowTriangle((10.2878,0.051,1.91641), (2.25999,0.051,9.91855), (-10.2877,0.051,1.83754))
        self.AddShadowTriangle((10.2878,0.051,-1.93329), (10.2878,0.051,1.91641), (-10.2877,0.051,1.83754))
        self.AddShadowTriangle((-10.2877,0.051,-1.8361), (10.2878,0.051,-1.93329), (-10.2877,0.051,1.83754))
        self.AddShadowTriangle((-2.26871,0.051,-9.92447), (2.49519,0.051,-9.92447), (10.2878,0.051,-1.93329))
        self.AddShadowTriangle((-10.2877,0.051,-1.8361), (-7.93688,0.051,-9.92447), (-2.26871,0.051,-9.92447))
        
    def HazardsOn(self, on):
        i=11
        while i<31:

            self.SetSubMaterialSound("boulder"+str(i), "metal", 15.0, "Sounds\\rockhit.wav")
            self.SetActive("boulder"+str(i), False)
            i +=1

        self.rocksound = plus.createSound("Sounds/rockroll.wav", False, (0, 0, 0))
        self.spikesound = plus.createSound("Sounds/woodspikehit.wav", False, (0, 0, 0))
        self.RegisterZone("zone",1)
        self.RegisterZone("zone2",2)


          

        #boulder run
        self.AddCollisionLine((-4, 30), (4, 30))
        self.AddCollisionLine((4, 30), (4, -30))
        self.AddCollisionLine((4, -30), (-4, -30))
        self.AddCollisionLine((-4, -30), (-4, 30))

        #Pit
        self.AddCollisionLine((25, 38), (25, -30))

        #Big rock
        self.AddCollisionLine((-30, 4), (-29, 3))
        self.AddCollisionLine((-29, 3), (-22, -7))
        self.AddCollisionLine((-22, -7), (-16, 0))
        self.AddCollisionLine((-16, 0), (-18, 5))
        self.AddCollisionLine((-18, 5), (-25, 7))
        self.AddCollisionLine((-25, 7), (-30, 4))

        #Mid Rock
        self.AddCollisionLine((14.6, 11.5), (23.2, 11.1))
        self.AddCollisionLine((23.2, 11.1), (23.3, 2.4))
        self.AddCollisionLine((23.3, 2.4), (14.1, 2.8))
        self.AddCollisionLine((14.1, 2.8), (14.6, 11.5))

        #Small rock
        self.AddCollisionLine((12.8, -4.75), (17.7, -5))
        self.AddCollisionLine((17.7, -5), (17.7, -10))
        self.AddCollisionLine((17.7, -10), (12.8, -10))
        self.AddCollisionLine((12.8, -10), (12.8, -4.75))

        #stalag 1
        self.AddCollisionLine((24.9, 19), (31.6, 5.2))

        #stalag 2
        self.AddCollisionLine((25.7, -2.7), (31, -2.7))
        self.AddCollisionLine((31, -2.7), (31, -8.3))
        self.AddCollisionLine((31, -8.3), (25.7, -8.3))
        self.AddCollisionLine((25.7, -8.3), (25.7, -2.7))

        self.AddPOV(0, (-44, 0), (0, 4))
        self.AddPOV(1, (-24, 20), (1, 5))
        self.AddPOV(2, (-24, -20), (1, 5))
        self.AddPOV(3, (-5, 0), (2, 0))
        self.AddPOV(4, (4, 0), (3, 1))
        self.AddPOV(5, (17, 22), (4, 2))
        self.AddPOV(6, (14, -17), (4, 2))
        self.AddPOV(7, (28, 0), (5, 3))



        return Arenas.SuperArena.HazardsOn(self, on)

    def Activate(self, on):
        if on: self.players = plus.getPlayers()
        
        Arenas.SuperArena.Activate(self, on)


    def ZoneEvent(self, direction, id, robot, chassis):
        if (robot ==1 or robot == 2 or robot == 3 or robot == 4) and direction ==1:

            if self.bHazardsOn:
                if id ==1 and self.nextrock < 31 and 19 < self.boltimer:
                    self.SetActive("boulder"+str(self.nextrock), True)
                    if self.nextrock > 12:
                        self.SetActive("boulder"+str((self.nextrock - 2)), False)
                    self.nextrock += 1
                    plus.playSound(self.rocksound)
                    self.boltimer = 0

            elif id ==2:
                #plus.force(robot-1, 0, 100 * plus.getWeight(robot-1), 0)
                plus.damage(robot-1, 0, 25000, plus.getLocation(robot-1))
                plus.playSound(self.spikesound)

        return True

    def Tick(self):

        self.boltimer +=1
        return Arenas.SuperArena.Tick(self)
        
Arenas.register(BoxArena)
